#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.Common;
using System.Runtime.InteropServices;

#endregion

namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>John Vrooland</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/31/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// Class FrmAssignWorkloadCodes
	/// </summary>
	public class FrmAssignWorkloadCodes : gov.va.med.vbecs.GUI.VbecsVistALinkBaseForm
	{
		#region Variables
		//
		private bool _initializeComplete = false;
		private bool _ignoreIndexChangeEvent = false;
		//
		private const string AddButtonMessage = "A workload and process must be selected.";
		private const string SaveButtonMessage = "There are no changes to save.";
		//
		private DataRow [] _sortedCodeDataRows;
		private DataRow [] _sortedProcedureDataRows;
		private ArrayList _vbecsProcessArray = new ArrayList();
		private ArrayList _addedInCurrentSession = new ArrayList();
		private BOL.VbecsProcess _vbecsProcess;
		private BOL.WorkLoad _workLoad;
		private string _workLoadCode;
		private bool _isLoading;
		//
		#endregion

		#region Form constrols

		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnLMIPClear;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnLMIPSave;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbLMIPNLTCode;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbLMIPProcedure;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbWorkloadProcess;
		private System.Windows.Forms.ColumnHeader colCost;
		private System.Windows.Forms.ColumnHeader colCPTCode;
		private System.Windows.Forms.ColumnHeader colLMIPNLT;
		private System.Windows.Forms.ColumnHeader colLMIPNLTActivation;
		private System.Windows.Forms.ColumnHeader colLMIPNLTInactivation;
		private System.Windows.Forms.ColumnHeader colProcess;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.DateTimePicker dtpLMIPNLTActivation;
		private System.Windows.Forms.DateTimePicker dtpLMIPNLTInactivation;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.GroupBox grpActivity;
		private System.Windows.Forms.GroupBox grpAdd;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpList;
		private System.Windows.Forms.Label lblLMIPNLTActivation;
		private System.Windows.Forms.Label lblLMIPNLTCode;
		private System.Windows.Forms.Label lblLMIPNLTInactivation;
		private System.Windows.Forms.Label lblLMIPProcedure;
		private System.Windows.Forms.Label lblWorkloadProcess;
		private System.Windows.Forms.ListView lvLMIPNLTCodes;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.ColumnHeader colActive;
		private System.Windows.Forms.Label lblWeightMultiplier;
		private System.Windows.Forms.TextBox txtWeightMultiplier;
		private System.Windows.Forms.ColumnHeader colWeightMultiplier;
		private System.Windows.Forms.CheckBox cbIncludeInactive;
		private System.Windows.Forms.ToolTip toolTip1;

		#endregion
 
		#region Constructors/Dispose

		//
		/// <summary>
		/// Constructor
		/// </summary>
		public FrmAssignWorkloadCodes()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC029AssignWorkloadCodes;

			_isLoading = true;			
			//
			InitializeComponent();
			//
			SetComponentProperties();
			//
			_isLoading = false;
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		///
		protected override void Dispose( bool disposing )
		{

			if( disposing )
			{

				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmAssignWorkloadCodes));
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.errorProvider1 = new System.Windows.Forms.ErrorProvider(this.components);
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.grpActivity = new System.Windows.Forms.GroupBox();
            this.cmbWorkloadProcess = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblWorkloadProcess = new System.Windows.Forms.Label();
            this.grpList = new System.Windows.Forms.GroupBox();
            this.cbIncludeInactive = new System.Windows.Forms.CheckBox();
            this.lvLMIPNLTCodes = new System.Windows.Forms.ListView();
            this.colActive = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colLMIPNLT = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colCPTCode = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colCost = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colWeightMultiplier = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colProcess = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colLMIPNLTActivation = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.colLMIPNLTInactivation = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpAdd = new System.Windows.Forms.GroupBox();
            this.txtWeightMultiplier = new System.Windows.Forms.TextBox();
            this.lblWeightMultiplier = new System.Windows.Forms.Label();
            this.dtpLMIPNLTInactivation = new System.Windows.Forms.DateTimePicker();
            this.cmbLMIPNLTCode = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.cmbLMIPProcedure = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblLMIPNLTCode = new System.Windows.Forms.Label();
            this.lblLMIPProcedure = new System.Windows.Forms.Label();
            this.lblLMIPNLTActivation = new System.Windows.Forms.Label();
            this.dtpLMIPNLTActivation = new System.Windows.Forms.DateTimePicker();
            this.lblLMIPNLTInactivation = new System.Windows.Forms.Label();
            this.btnLMIPSave = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnLMIPClear = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancel = new System.Windows.Forms.Button();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.errorProvider1)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpActivity.SuspendLayout();
            this.grpList.SuspendLayout();
            this.grpAdd.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(596, 30);
            this.vbecsLogo1.TabIndex = 5;
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 463);
            this.lblRequiredField.TabIndex = 7;
            // 
            // errorProvider1
            // 
            this.errorProvider1.ContainerControl = this;
            this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(56, 416);
            this.grpImage.TabIndex = 6;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // grpActivity
            // 
            this.grpActivity.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpActivity.Controls.Add(this.cmbWorkloadProcess);
            this.grpActivity.Controls.Add(this.lblWorkloadProcess);
            this.grpActivity.Location = new System.Drawing.Point(64, 32);
            this.grpActivity.Name = "grpActivity";
            this.grpActivity.Size = new System.Drawing.Size(528, 44);
            this.grpActivity.TabIndex = 0;
            this.grpActivity.TabStop = false;
            // 
            // cmbWorkloadProcess
            // 
            this.cmbWorkloadProcess.AccessibleDescription = "Workload Process";
            this.cmbWorkloadProcess.AccessibleName = "Workload Process";
            this.cmbWorkloadProcess.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbWorkloadProcess.Interval = 500;
            this.cmbWorkloadProcess.Location = new System.Drawing.Point(112, 16);
            this.cmbWorkloadProcess.Name = "cmbWorkloadProcess";
            this.cmbWorkloadProcess.Size = new System.Drawing.Size(396, 22);
            this.cmbWorkloadProcess.TabIndex = 1;
            this.cmbWorkloadProcess.SelectedIndexChanged += new System.EventHandler(this.cmbWorkloadProcess_SelectedIndexChanged);
            // 
            // lblWorkloadProcess
            // 
            this.lblWorkloadProcess.Location = new System.Drawing.Point(8, 16);
            this.lblWorkloadProcess.Name = "lblWorkloadProcess";
            this.lblWorkloadProcess.Size = new System.Drawing.Size(101, 20);
            this.lblWorkloadProcess.TabIndex = 0;
            this.lblWorkloadProcess.Text = "Workload Process*";
            this.lblWorkloadProcess.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpList
            // 
            this.grpList.AccessibleDescription = "Current Associations";
            this.grpList.AccessibleName = "Current Associations";
            this.grpList.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpList.Controls.Add(this.cbIncludeInactive);
            this.grpList.Controls.Add(this.lvLMIPNLTCodes);
            this.grpList.Location = new System.Drawing.Point(64, 212);
            this.grpList.Name = "grpList";
            this.grpList.Size = new System.Drawing.Size(528, 236);
            this.grpList.TabIndex = 2;
            this.grpList.TabStop = false;
            this.grpList.Text = "Current Associations";
            // 
            // cbIncludeInactive
            // 
            this.cbIncludeInactive.AccessibleDescription = "Show Inactive Workload Codes";
            this.cbIncludeInactive.AccessibleName = "Show Inactive Workload Codes";
            this.cbIncludeInactive.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.cbIncludeInactive.Location = new System.Drawing.Point(8, 216);
            this.cbIncludeInactive.Name = "cbIncludeInactive";
            this.cbIncludeInactive.Size = new System.Drawing.Size(184, 16);
            this.cbIncludeInactive.TabIndex = 1;
            this.cbIncludeInactive.Text = "&Show Inactive Workload Codes";
            this.cbIncludeInactive.CheckedChanged += new System.EventHandler(this.cbIncludeInactive_CheckedChanged);
            // 
            // lvLMIPNLTCodes
            // 
            this.lvLMIPNLTCodes.AccessibleDescription = "Current Associations";
            this.lvLMIPNLTCodes.AccessibleName = "Current Associations";
            this.lvLMIPNLTCodes.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvLMIPNLTCodes.CheckBoxes = true;
            this.lvLMIPNLTCodes.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.colActive,
            this.colLMIPNLT,
            this.colCPTCode,
            this.colCost,
            this.colWeightMultiplier,
            this.colProcess,
            this.colLMIPNLTActivation,
            this.colLMIPNLTInactivation});
            this.lvLMIPNLTCodes.FullRowSelect = true;
            this.lvLMIPNLTCodes.Location = new System.Drawing.Point(8, 20);
            this.lvLMIPNLTCodes.MultiSelect = false;
            this.lvLMIPNLTCodes.Name = "lvLMIPNLTCodes";
            this.lvLMIPNLTCodes.Size = new System.Drawing.Size(512, 192);
            this.lvLMIPNLTCodes.TabIndex = 0;
            this.lvLMIPNLTCodes.UseCompatibleStateImageBehavior = false;
            this.lvLMIPNLTCodes.View = System.Windows.Forms.View.Details;
            this.lvLMIPNLTCodes.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvLMIPNLTCodes_ColumnClick);
            this.lvLMIPNLTCodes.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvLMIPNLTCodes_ItemCheck);
            this.lvLMIPNLTCodes.ItemChecked += new System.Windows.Forms.ItemCheckedEventHandler(this.lvLMIPNLTCodes_ItemChecked);
            this.lvLMIPNLTCodes.SelectedIndexChanged += new System.EventHandler(this.lvLMIPNLTCodes_Selected);
            this.lvLMIPNLTCodes.Click += new System.EventHandler(this.lvLMIPNLTCodes_Selected);
            // 
            // colActive
            // 
            this.colActive.Text = "Active";
            this.colActive.Width = 45;
            // 
            // colLMIPNLT
            // 
            this.colLMIPNLT.Text = "LMIP/NLT Code";
            this.colLMIPNLT.Width = 100;
            // 
            // colCPTCode
            // 
            this.colCPTCode.Text = "CPT Code";
            // 
            // colCost
            // 
            this.colCost.Text = "Cost";
            // 
            // colWeightMultiplier
            // 
            this.colWeightMultiplier.Text = "Weight";
            this.colWeightMultiplier.Width = 92;
            // 
            // colProcess
            // 
            this.colProcess.Text = "LMIP Procedure";
            this.colProcess.Width = 120;
            // 
            // colLMIPNLTActivation
            // 
            this.colLMIPNLTActivation.Text = "Start Date";
            this.colLMIPNLTActivation.Width = 80;
            // 
            // colLMIPNLTInactivation
            // 
            this.colLMIPNLTInactivation.Text = "Stop Date";
            this.colLMIPNLTInactivation.Width = 80;
            // 
            // grpAdd
            // 
            this.grpAdd.AccessibleDescription = "Select L M I P N L T Process Association";
            this.grpAdd.AccessibleName = "Select L M I P N L T Process Association";
            this.grpAdd.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpAdd.Controls.Add(this.txtWeightMultiplier);
            this.grpAdd.Controls.Add(this.lblWeightMultiplier);
            this.grpAdd.Controls.Add(this.dtpLMIPNLTInactivation);
            this.grpAdd.Controls.Add(this.cmbLMIPNLTCode);
            this.grpAdd.Controls.Add(this.cmbLMIPProcedure);
            this.grpAdd.Controls.Add(this.lblLMIPNLTCode);
            this.grpAdd.Controls.Add(this.lblLMIPProcedure);
            this.grpAdd.Controls.Add(this.lblLMIPNLTActivation);
            this.grpAdd.Controls.Add(this.dtpLMIPNLTActivation);
            this.grpAdd.Controls.Add(this.lblLMIPNLTInactivation);
            this.grpAdd.Controls.Add(this.btnLMIPSave);
            this.grpAdd.Controls.Add(this.btnLMIPClear);
            this.grpAdd.Location = new System.Drawing.Point(64, 80);
            this.grpAdd.Name = "grpAdd";
            this.grpAdd.Size = new System.Drawing.Size(528, 128);
            this.grpAdd.TabIndex = 0;
            this.grpAdd.TabStop = false;
            this.grpAdd.Text = "Select LMIP/NLT Process Association";
            // 
            // txtWeightMultiplier
            // 
            this.txtWeightMultiplier.AccessibleDescription = "Weight Multiplier";
            this.txtWeightMultiplier.AccessibleName = "Weight Multiplier";
            this.txtWeightMultiplier.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtWeightMultiplier.Location = new System.Drawing.Point(112, 68);
            this.txtWeightMultiplier.Name = "txtWeightMultiplier";
            this.txtWeightMultiplier.ReadOnly = true;
            this.txtWeightMultiplier.Size = new System.Drawing.Size(152, 20);
            this.txtWeightMultiplier.TabIndex = 5;
            // 
            // lblWeightMultiplier
            // 
            this.lblWeightMultiplier.Location = new System.Drawing.Point(8, 68);
            this.lblWeightMultiplier.Name = "lblWeightMultiplier";
            this.lblWeightMultiplier.Size = new System.Drawing.Size(90, 20);
            this.lblWeightMultiplier.TabIndex = 4;
            this.lblWeightMultiplier.Text = "Weight Multiplier";
            this.lblWeightMultiplier.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // dtpLMIPNLTInactivation
            // 
            this.dtpLMIPNLTInactivation.AccessibleDescription = "Stop Date";
            this.dtpLMIPNLTInactivation.AccessibleName = "Stop Date";
            this.dtpLMIPNLTInactivation.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.dtpLMIPNLTInactivation.CustomFormat = "";
            this.dtpLMIPNLTInactivation.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpLMIPNLTInactivation.Location = new System.Drawing.Point(380, 68);
            this.dtpLMIPNLTInactivation.MinDate = new System.DateTime(1999, 12, 31, 0, 0, 0, 0);
            this.dtpLMIPNLTInactivation.Name = "dtpLMIPNLTInactivation";
            this.dtpLMIPNLTInactivation.Size = new System.Drawing.Size(128, 20);
            this.dtpLMIPNLTInactivation.TabIndex = 9;
            this.dtpLMIPNLTInactivation.Enter += new System.EventHandler(this.dtpLMIPNLTInactivation_Enter);
            this.dtpLMIPNLTInactivation.KeyDown += new System.Windows.Forms.KeyEventHandler(this.dtpLMIPNLTInactivation_KeyDown);
            this.dtpLMIPNLTInactivation.Leave += new System.EventHandler(this.dtpLMIPNLTInactivation_Leave);
            // 
            // cmbLMIPNLTCode
            // 
            this.cmbLMIPNLTCode.AccessibleDescription = "L M I P N L T Code";
            this.cmbLMIPNLTCode.AccessibleName = "L M I P N L T Code";
            this.cmbLMIPNLTCode.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbLMIPNLTCode.Interval = 500;
            this.cmbLMIPNLTCode.Location = new System.Drawing.Point(112, 44);
            this.cmbLMIPNLTCode.MaxDropDownItems = 4;
            this.cmbLMIPNLTCode.MaxLength = 7;
            this.cmbLMIPNLTCode.Name = "cmbLMIPNLTCode";
            this.cmbLMIPNLTCode.Size = new System.Drawing.Size(152, 22);
            this.cmbLMIPNLTCode.TabIndex = 3;
            this.cmbLMIPNLTCode.SelectedIndexChanged += new System.EventHandler(this.cmbLMIPNLTCode_SelectedIndexChanged);
            // 
            // cmbLMIPProcedure
            // 
            this.cmbLMIPProcedure.AccessibleDescription = "L M I P Procedure";
            this.cmbLMIPProcedure.AccessibleName = "L M I P Procedure";
            this.cmbLMIPProcedure.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbLMIPProcedure.Interval = 500;
            this.cmbLMIPProcedure.Location = new System.Drawing.Point(112, 20);
            this.cmbLMIPProcedure.Name = "cmbLMIPProcedure";
            this.cmbLMIPProcedure.Size = new System.Drawing.Size(396, 22);
            this.cmbLMIPProcedure.TabIndex = 1;
            this.cmbLMIPProcedure.SelectedIndexChanged += new System.EventHandler(this.cmbLMIPProcedure_SelectedIndexChanged);
            // 
            // lblLMIPNLTCode
            // 
            this.lblLMIPNLTCode.Location = new System.Drawing.Point(8, 44);
            this.lblLMIPNLTCode.Name = "lblLMIPNLTCode";
            this.lblLMIPNLTCode.Size = new System.Drawing.Size(90, 20);
            this.lblLMIPNLTCode.TabIndex = 2;
            this.lblLMIPNLTCode.Text = "LMIP/NLT Code*";
            this.lblLMIPNLTCode.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblLMIPProcedure
            // 
            this.lblLMIPProcedure.Location = new System.Drawing.Point(8, 20);
            this.lblLMIPProcedure.Name = "lblLMIPProcedure";
            this.lblLMIPProcedure.Size = new System.Drawing.Size(90, 20);
            this.lblLMIPProcedure.TabIndex = 0;
            this.lblLMIPProcedure.Text = "LMIP Procedure*";
            this.lblLMIPProcedure.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblLMIPNLTActivation
            // 
            this.lblLMIPNLTActivation.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.lblLMIPNLTActivation.Location = new System.Drawing.Point(320, 44);
            this.lblLMIPNLTActivation.Name = "lblLMIPNLTActivation";
            this.lblLMIPNLTActivation.Size = new System.Drawing.Size(60, 20);
            this.lblLMIPNLTActivation.TabIndex = 6;
            this.lblLMIPNLTActivation.Text = "Start Date*";
            this.lblLMIPNLTActivation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // dtpLMIPNLTActivation
            // 
            this.dtpLMIPNLTActivation.AccessibleDescription = "Start Date";
            this.dtpLMIPNLTActivation.AccessibleName = "Start Date";
            this.dtpLMIPNLTActivation.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.dtpLMIPNLTActivation.CustomFormat = "";
            this.dtpLMIPNLTActivation.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpLMIPNLTActivation.Location = new System.Drawing.Point(380, 44);
            this.dtpLMIPNLTActivation.MinDate = new System.DateTime(1999, 12, 31, 0, 0, 0, 0);
            this.dtpLMIPNLTActivation.Name = "dtpLMIPNLTActivation";
            this.dtpLMIPNLTActivation.Size = new System.Drawing.Size(128, 20);
            this.dtpLMIPNLTActivation.TabIndex = 7;
            this.dtpLMIPNLTActivation.ValueChanged += new System.EventHandler(this.dtpLMIPNLTActivation_ValueChanged);
            // 
            // lblLMIPNLTInactivation
            // 
            this.lblLMIPNLTInactivation.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.lblLMIPNLTInactivation.Location = new System.Drawing.Point(320, 68);
            this.lblLMIPNLTInactivation.Name = "lblLMIPNLTInactivation";
            this.lblLMIPNLTInactivation.Size = new System.Drawing.Size(60, 20);
            this.lblLMIPNLTInactivation.TabIndex = 8;
            this.lblLMIPNLTInactivation.Text = "Stop Date";
            this.lblLMIPNLTInactivation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnLMIPSave
            // 
            this.btnLMIPSave.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnLMIPSave.EnabledButton = false;
            this.btnLMIPSave.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnLMIPSave.Image = ((System.Drawing.Image)(resources.GetObject("btnLMIPSave.Image")));
            this.btnLMIPSave.Location = new System.Drawing.Point(352, 96);
            this.btnLMIPSave.Name = "btnLMIPSave";
            this.btnLMIPSave.Size = new System.Drawing.Size(75, 23);
            this.btnLMIPSave.TabIndex = 10;
            this.btnLMIPSave.Click += new System.EventHandler(this.btnLMIPSave_Click);
            // 
            // btnLMIPClear
            // 
            this.btnLMIPClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnLMIPClear.Location = new System.Drawing.Point(432, 96);
            this.btnLMIPClear.Name = "btnLMIPClear";
            this.btnLMIPClear.Size = new System.Drawing.Size(75, 23);
            this.btnLMIPClear.TabIndex = 11;
            this.btnLMIPClear.Text = "C&lear";
            this.btnLMIPClear.Click += new System.EventHandler(this.btnLMIPClear_Click);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.Location = new System.Drawing.Point(436, 452);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 3;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(516, 452);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 4;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // FrmAssignWorkloadCodes
            // 
            this.AcceptButton = this.btnLMIPSave;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(596, 477);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.grpActivity);
            this.Controls.Add(this.grpList);
            this.Controls.Add(this.grpAdd);
            this.hlphelpChm.SetHelpKeyword(this, "Assign_Workload_Codes.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 500);
            this.Name = "FrmAssignWorkloadCodes";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Assign Workload Codes";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmAssignWorkloadCodes_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.grpAdd, 0);
            this.Controls.SetChildIndex(this.grpList, 0);
            this.Controls.SetChildIndex(this.grpActivity, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.errorProvider1)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpActivity.ResumeLayout(false);
            this.grpList.ResumeLayout(false);
            this.grpAdd.ResumeLayout(false);
            this.grpAdd.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

		}

		#endregion

		#region Events

		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// btnCancel_Click Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// btnLMIPClear_Click Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnLMIPClear_Click(object sender, System.EventArgs e)
		{
			_workLoad = null;
			dtpLMIPNLTActivation.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			dtpLMIPNLTInactivation.Value = dtpLMIPNLTInactivation.MinDate;
			dtpLMIPNLTInactivation.CustomFormat = " ";
			cmbLMIPNLTCode.SelectedIndex = -1;
			cmbLMIPProcedure.SelectedIndex = -1;
			txtWeightMultiplier.Text = string.Empty;
		}

		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// btnLMIPSave_Click Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnLMIPSave_Click(object sender, System.EventArgs e)
		{
			try 
			{
				if( !this.WorkLoadAlreadyAdded() || btnLMIPSave.Text.Equals("&Update") ) 
				{
					if (!this.SetLocks(this._vbecsProcess.VbecsProcessGuid)) return;

					if (_workLoad == null || _workLoad.WorkloadCode != _workLoadCode) 
					{
						_workLoad = _vbecsProcess.GetNewWorkLoad(_workLoadCode);
						// setting the event to fire the setdirtyflag function
						_workLoad.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
						_workLoad.UpdateRecordStatusCode(Common.RecordStatusCode.Active);
						_addedInCurrentSession.Add(_workLoad.RowVersion);
					}

					if (_workLoad == null)
					{
						btnLMIPSave.EnabledButton = false;
						this.btnLMIPSave.SetToolTip(AddButtonMessage);
						return;
					}
					_workLoad.AssignedDate = dtpLMIPNLTActivation.Value;

					if (dtpLMIPNLTInactivation.Value != dtpLMIPNLTActivation.MinDate)
					{
						_workLoad.UnAssignedDate = dtpLMIPNLTInactivation.Value;
					}
					else
					{
						_workLoad.UnAssignedDate = DateTime.MinValue;
					}

					_vbecsProcess.AddItem(_workLoad);

					if( !this._vbecsProcessArray.Contains(_vbecsProcess) ) 
					{
						this._vbecsProcessArray.Add(_vbecsProcess);
					}

					PopulateListView();
					btnOK.EnabledButton = true;
					this.btnOK.SetToolTip(String.Empty);
				}
			}
			catch (Exception)
			{
				SystemError("Unable to save new item.");
			}
		}

		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// btnOK_Click Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("workload code")) != DialogResult.Yes)
			{
				return;
			}
			//
			try
			{
				foreach(BOL.VbecsProcess vbecsProcess in this._vbecsProcessArray)
				{
					vbecsProcess.SaveChanges(Common.UpdateFunction.UC029FrmAssignWorkloadCodes);
				}
			}
			catch (RowVersionException)
			{
				this.btnOK.RowVersionException = true;		//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
			}
			// 
			// No longer dirty, close window.
			this.IsDirty = false;
			this.Close();
		}

		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// cmbLMIPNLTCode_SelectedIndexChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbLMIPNLTCode_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(!_isLoading && !_ignoreIndexChangeEvent)
			{ 
				if( cmbLMIPNLTCode.SelectedItem != null && cmbLMIPNLTCode.SelectedIndex > -1 )
				{
					_workLoadCode = ((LMIPItem)cmbLMIPNLTCode.SelectedItem).LMIP;
					//
					// select corresponding procedure
					string procedure = this._sortedCodeDataRows[cmbLMIPNLTCode.SelectedIndex]["Procedure"].ToString();
					int procedureIdx = this.cmbLMIPProcedure.FindString( procedure );
					//
					this._ignoreIndexChangeEvent = true;
					this.cmbLMIPProcedure.SelectedIndex = procedureIdx;
					this._workLoadCode = ((LMIPItem)cmbLMIPNLTCode.SelectedItem).LMIP;
					this._ignoreIndexChangeEvent = false;
					//
					// Get weight multiplier
					txtWeightMultiplier.Text = BOL.VbecsProcess.GetWeightMultiplier(cmbLMIPNLTCode.Text);
					//
					btnLMIPSave.EnabledButton = true;
					this.btnLMIPSave.SetToolTip(string.Empty);
				}
				else
				{
					btnLMIPSave.EnabledButton = false;
					this.btnLMIPSave.SetToolTip(AddButtonMessage);
					//
					btnLMIPSave.Text = "&Add";
					_workLoad = null;
					//
					// Previously attached as second event handler, which gets cleared when auto code regenerated, so adding here instead
					this.SetDirtyFlag(sender,e);
				}
			}
		}

		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// cmbLMIPProcedure_SelectedIndexChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbLMIPProcedure_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(!_isLoading && !_ignoreIndexChangeEvent)
			{
				if ( cmbLMIPProcedure.SelectedItem != null && cmbLMIPProcedure.SelectedIndex > -1 )
				{
					this.ClearInactiveDate();
					//
					// select corresponding procedure
					string code = this._sortedProcedureDataRows[cmbLMIPProcedure.SelectedIndex]["LMIP"].ToString();
					int codeIdx = this.cmbLMIPNLTCode.FindString( code );
					//
					this._ignoreIndexChangeEvent = true;
					this.cmbLMIPNLTCode.SelectedIndex = codeIdx;
					this._workLoadCode = ((LMIPItem)cmbLMIPNLTCode.SelectedItem).LMIP;
					this._ignoreIndexChangeEvent = false;
					//
					// Get weight multiplier
					txtWeightMultiplier.Text = BOL.VbecsProcess.GetWeightMultiplier(cmbLMIPNLTCode.Text);
					//
					btnLMIPSave.EnabledButton = true;
					this.btnLMIPSave.SetToolTip(string.Empty);
				}
				else
				{
					btnLMIPSave.EnabledButton = false;
					this.btnLMIPSave.SetToolTip(AddButtonMessage);
				}
				//
				btnLMIPSave.Text = "&Add";
				_workLoad = null;
				//
				// Previously attached as second event handler, which gets cleared when auto code regenerated, so adding here instead
				this.SetDirtyFlag(sender,e);
			}
		}

		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// cmbWorkloadProcess_SelectedIndexChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbWorkloadProcess_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.ClearInactiveDate();

			if (cmbWorkloadProcess.SelectedItem != null && !_isLoading) 
			{
				try 
				{
					_vbecsProcess = ((ProcessItem)cmbWorkloadProcess.SelectedItem).VbecsProcess;

					//
					if (cmbLMIPProcedure.Items.Count > 0)
					{
						cmbLMIPProcedure.SelectedIndex = -1;
					}
					//
					if (cmbLMIPNLTCode.Items.Count > 0)
					{
						cmbLMIPNLTCode.SelectedIndex = -1;
					}
					//
					dtpLMIPNLTActivation.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					dtpLMIPNLTInactivation.Value = dtpLMIPNLTInactivation.MinDate;
					//
					PopulateListView();
					//
					grpAdd.Enabled = true;
					grpList.Enabled = true;
					//
					cmbLMIPProcedure.Focus();
					return;
				}
				catch( BusinessObjectException ex)
				{
					ExceptionManagement.ExceptionManager.Publish(ex);
					SystemError("Unable to process selected item.");
				}
			}
			else
			{
				_vbecsProcess = null;
				cmbLMIPNLTCode.SelectedIndex = -1;
				cmbLMIPProcedure.SelectedIndex = -1;
				grpAdd.Enabled = false;
				grpList.Enabled = false;
				this.lvLMIPNLTCodes.Items.Clear();
			}

			// Previously attached as second event handler, which gets cleared when auto code regenerated, so adding here instead
			this.SetDirtyFlag( sender, e );
		}

		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// dtpLMIPNLTActivation_ValueChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpLMIPNLTActivation_ValueChanged(object sender, System.EventArgs e)
		{
			if(!_isLoading)
			{

				if (dtpLMIPNLTInactivation.Value != dtpLMIPNLTInactivation.MinDate && 
					dtpLMIPNLTInactivation.Value < dtpLMIPNLTActivation.Value) 
				{
					dtpLMIPNLTInactivation.Value = dtpLMIPNLTActivation.Value;
				}
			}
		}

		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// dtpLMIPNLTInactivation_Enter Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpLMIPNLTInactivation_Enter(object sender, System.EventArgs e)
		{
			if (dtpLMIPNLTInactivation.Value < dtpLMIPNLTActivation.Value) 
			{
				SetInactiveDate(dtpLMIPNLTActivation.Value);
			}
			dtpLMIPNLTInactivation.CustomFormat = Common.VBECSDateTime.DateFormat;
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// dtpLMIPNLTInactivation_KeyDown Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpLMIPNLTInactivation_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (e.KeyData == Keys.Delete) 
			{
				ClearInactiveDate();
			}
		}

		//
		/// <summary>
		/// Implements BR_29.06
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpLMIPNLTInactivation_Leave(object sender, System.EventArgs e)
		{
			if (dtpLMIPNLTInactivation.Value == dtpLMIPNLTInactivation.MinDate) 
			{
				ClearInactiveDate();
			}
			else
			{
				if ( dtpLMIPNLTInactivation.Value.Date < dtpLMIPNLTActivation.Value.Date ) 
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC029.InvalidInactivationDate());
					this.dtpLMIPNLTInactivation.Focus();
					SetInactiveDate(dtpLMIPNLTActivation.Value);
				}
				dtpLMIPNLTInactivation.CustomFormat = Common.VBECSDateTime.DateFormat;
			}
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// lvLMIPNLTCodes_ColumnClick Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvLMIPNLTCodes_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if ( e.Column == 6 || e.Column == 7 )
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvLMIPNLTCodes.CheckBoxes, ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				if ( e.Column == 4 )
				{
					ColumnClickSorter.ColumnClickHandler(sender, e, lvLMIPNLTCodes.CheckBoxes, ColumnClickSorter.ColumnSortType.Integer);
				}
				else
				{
					ColumnClickSorter.ColumnClickHandler(sender, e, lvLMIPNLTCodes.CheckBoxes, 	ColumnClickSorter.ColumnSortType.String);
				}
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/09/2006</CreationDate>
		///
		/// <summary>
		/// returns index of Lmip Procedure in 
		/// cmbLMIPProcedure.Items or -1 if not
		/// found
		/// </summary>
		/// <param name="procedure"></param>
		/// <returns>int</returns>
		private int FindLmipProcedureIndex(string procedure)
		{
			for (int idx = 0; idx < this.cmbLMIPProcedure.Items.Count; idx++)
			{
				if (this.cmbLMIPProcedure.Items[idx].ToString().Equals(procedure))
				{
					return idx;
				}
			}
			//
			return -1;
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/09/2006</CreationDate>
		///
		/// <summary>
		/// lvLMIPNLTCodes_Selected Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvLMIPNLTCodes_Selected(object sender, EventArgs e)
		{
			if (lvLMIPNLTCodes.SelectedItems.Count > 0)
			{
				WorkLoad wl = (WorkLoad)lvLMIPNLTCodes.SelectedItems[0].Tag;
				int index = cmbLMIPNLTCode.FindString(wl.WorkloadCode);

				if (index > -1)
				{
					this.cmbLMIPProcedure.SelectedIndex = FindLmipProcedureIndex(wl.WorkloadProcedure);

					if (wl.AssignedDate > dtpLMIPNLTActivation.MinDate) 
					{
						dtpLMIPNLTActivation.CustomFormat = Common.VBECSDateTime.DateFormat;
						dtpLMIPNLTActivation.Value = wl.AssignedDate;
					}

					else
					{
						dtpLMIPNLTActivation.CustomFormat = Common.VBECSDateTime.DateFormat;
						dtpLMIPNLTActivation.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					}

					if (wl.UnAssignedDate > dtpLMIPNLTInactivation.MinDate) 
					{
						SetInactiveDate(wl.UnAssignedDate);
					}
					else
					{
						ClearInactiveDate();
					}
					_workLoad = wl;
					btnLMIPSave.Text = "&Update";
				}
			}
			this.SpeakListViewWithCheckBox(lvLMIPNLTCodes);
		}

		/// <summary>
		/// lvLMIPNLTCodes_ItemCheck Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvLMIPNLTCodes_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (!_isLoading)
			{
				// Fire this off because they're making a change -- Any change & lock the process
				if(!this.SetLocks(this._vbecsProcess.VbecsProcessGuid))
				{
					e.NewValue = e.CurrentValue;
					return;
				}

				_workLoad = (BOL.WorkLoad) this.lvLMIPNLTCodes.Items[e.Index].Tag;
				// setting the event to fire the setdirtyflag function
				_workLoad.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
				_workLoad.Invalid += new System.EventHandler(this.SetDirtyFlag);
				//
				if (e.NewValue == CheckState.Unchecked)
				{
					_workLoad.UpdateRecordStatusCode(Common.RecordStatusCode.Inactive);
					_vbecsProcess.AddItem(_workLoad);
				}
				else
				{
					_workLoad.UpdateRecordStatusCode(Common.RecordStatusCode.Active);
					_vbecsProcess.AddItem(_workLoad);
				}
				//
				// list view has been updated, page is dirty.
				this.IsDirty = true;
				btnOK.EnabledButton = true;
				this.btnOK.SetToolTip(String.Empty);

				// For saving the process
				if (!this._vbecsProcessArray.Contains(_vbecsProcess))
				{
					this._vbecsProcessArray.Add(_vbecsProcess);
				}
			}
		}

        //CR 3316
        private void lvLMIPNLTCodes_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            if (!_isLoading)
            {
                PopulateListView();
            }
        }

		/// <summary>
		/// OnVistALinkFormLoad Event
		/// </summary>
		/// <param name="e"></param>
		protected override void OnVistALinkFormLoad( EventArgs e )
		{
			Initialize();
		}

		/// <summary>
		/// cbIncludeInactive_CheckedChanged Event Handler
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbIncludeInactive_CheckedChanged(object sender, System.EventArgs e)
		{
			this.PopulateListView();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmAssignWorkloadCodes_KeyDownSpeakMessage(object sender, EventArgs e)
		{ 
			string textToSpeak = string.Empty;
			//
			textToSpeak = string.Concat( this.btnLMIPSave.GetToolTip(), " ", this.btnOK.GetToolTip() );
			//
			this.SpeakMessage( textToSpeak );
		}

		#endregion

		#region Methods

		//
		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>06/01/2005</CreationDate>
		///
		/// <summary>
		/// Determines whether workload code and procedure 
		/// are already in the list
		/// Implements BR_29.08
		/// </summary>
		private bool WorkLoadAlreadyAdded()
		{
			int itemCount = this.lvLMIPNLTCodes.Items.Count;
			//
			string newWorkLoadProcedure = cmbLMIPProcedure.Text;
			string newWorkLoadCode = cmbLMIPNLTCode.Text;
			//
			for ( int idx = 0; idx < itemCount; idx++ )
			{
				WorkLoad workLoad = (WorkLoad)this.lvLMIPNLTCodes.Items[idx].Tag;
				//
				if( newWorkLoadProcedure.Equals( workLoad.WorkloadProcedure ) && newWorkLoadCode.Equals( workLoad.WorkloadCode ) )
				{
					return true;
				}
			}
			//
			return false;
		}

		//
		private void ClearInactiveDate()
		{
			dtpLMIPNLTInactivation.Value = dtpLMIPNLTInactivation.MinDate;
			dtpLMIPNLTInactivation.CustomFormat = " ";
		}

		//
		private void SetInactiveDate(DateTime inactDate)
		{
			dtpLMIPNLTInactivation.Value = inactDate;
			dtpLMIPNLTInactivation.CustomFormat = Common.VBECSDateTime.DateFormat;
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// Initialize
		/// </summary>
		private void Initialize()
		{
			this.Refresh();

			using (new WaitCursor()) 
			{
				grpAdd.Enabled = false;
				grpList.Enabled = false;
				//
				this.Refresh();
				//
				cmbWorkloadProcess.Items.Clear();
				cmbLMIPNLTCode.Items.Clear();
				//
				VbecsProcess[] vpAr = VbecsProcess.GetAllVbecsProcesses();
				for ( int idx = 0; idx < vpAr.Length; idx++ )
				{
					cmbWorkloadProcess.Items.Add( new ProcessItem( vpAr[idx] ) );
				}

				//
				// Note: dtw columns: LMIP, Procedure, Cost, WeightMultiplier, Code_Id
				DataTable dtw = VbecsProcess.GetAllVistaWorkloads();
				//
				// We keep two arrays of data rows: one is sorted by code, the
				// other is sorted by procedure.  This is done so that we may
				// have both combo boxes sorted yet still display the correct
				// code for the chosen procedure and vise versa.
				//
				// Sort table by 'Code'
				this._sortedCodeDataRows = dtw.Select( "", "LMIP ASC" );
				for ( int idx = 0; idx < this._sortedCodeDataRows.Length; idx++ )
				{
					LMIPItem lmip = new LMIPItem( this._sortedCodeDataRows[idx] );
					cmbLMIPNLTCode.Items.Add( lmip );
				}
				//
				// Sort table by 'Procedure'
				this._sortedProcedureDataRows = dtw.Select( "", "Procedure ASC" );
				for ( int idx = 0; idx < this._sortedProcedureDataRows.Length; idx++ )
				{
					ProcedureItem pi = new ProcedureItem( this._sortedProcedureDataRows[idx] );
					cmbLMIPProcedure.Items.Add( pi );
				}
				//
				_initializeComplete = true;
			}
		}

		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// PopulateListView
		/// </summary>
		private void PopulateListView()
		{
			_isLoading = true;
			lvLMIPNLTCodes.Items.Clear();

			//
			try 
			{	
				foreach ( DataRowView drv in this._vbecsProcess.WorkLoads )
				{
					WorkLoad wl = this._vbecsProcess.GetWorkLoad((System.Guid)drv[Common.VbecsTables.WorkloadProcess.WorkloadProcessGuid]);

					if (wl.CPTCodes.Count > 0) 
					{
						foreach ( string cptCode in wl.CPTCodes  )
						{
							ListViewItem lviLMIP  = new ListViewItem();
							//
							if (wl.RecordStatusCode == Common.RecordStatusCode.Active)
							{
								lviLMIP.Checked = true;
							}
							else
							{
								if (!this.cbIncludeInactive.Checked)
								{
									continue;
								}
								else
								{
									lviLMIP.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
									lviLMIP.Checked = false;
								}
							}
							//
							lviLMIP.Tag = wl;
							//
							lviLMIP.SubItems.Add(wl.WorkloadCode);
							lviLMIP.SubItems.Add(cptCode);
							lviLMIP.SubItems.Add(wl.Cost.ToString("C"));
							lviLMIP.SubItems.Add(wl.WeightMultiplier.ToString());
							lviLMIP.SubItems.Add(wl.WorkloadProcedure);

							if (wl.AssignedDate != DateTime.MinValue) 
							{
								lviLMIP.SubItems.Add(Common.VBECSDateTime.FormatDateString(wl.AssignedDate));
							}
							else
							{
								lviLMIP.SubItems.Add("");
							}

							if (wl.UnAssignedDate != DateTime.MinValue) 
							{
								lviLMIP.SubItems.Add(Common.VBECSDateTime.FormatDateString(wl.UnAssignedDate));
							}
							else
							{
								// Add empty spaces so the column doesn't disappear when no date 
								// is chosen.
								lviLMIP.SubItems.Add("       ");
							}
							//
							lvLMIPNLTCodes.Items.Add( lviLMIP );
						}
					}

					else
					{
						ListViewItem lviLMIP  = new ListViewItem();
						lviLMIP.Tag = wl;

						//
						if (wl.RecordStatusCode == Common.RecordStatusCode.Active)
						{
							lviLMIP.Checked = true;
						}
						else
						{
							if (!this.cbIncludeInactive.Checked)
							{
								continue;
							}
							else
							{
								lviLMIP.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
								lviLMIP.Checked = false;
							}
						}
						lviLMIP.SubItems.Add(wl.WorkloadCode);
						lviLMIP.SubItems.Add(""); // No CPTCode
						lviLMIP.SubItems.Add(wl.Cost.ToString("C"));
						lviLMIP.SubItems.Add(wl.WeightMultiplier.ToString());
						lviLMIP.SubItems.Add(wl.WorkloadProcedure);

						if (wl.AssignedDate != DateTime.MinValue) 
						{
							lviLMIP.SubItems.Add(Common.VBECSDateTime.FormatDateString(wl.AssignedDate));
						}
						else
						{
							lviLMIP.SubItems.Add("");
						}

						if (wl.UnAssignedDate != DateTime.MinValue) 
						{
							lviLMIP.SubItems.Add(Common.VBECSDateTime.FormatDateString(wl.UnAssignedDate));
						}
						else
						{
							lviLMIP.SubItems.Add("");
						}
						//
						lvLMIPNLTCodes.Items.Add(lviLMIP);
					}
				}
			}
			catch (Exception ex) 
			{
				ExceptionManagement.ExceptionManager.Publish(ex);
				SystemError("Unable to display existing items.");
			}
			controls.VbecsFunction.SetColumnWidths(lvLMIPNLTCodes);
			this.lvLMIPNLTCodes.Refresh();
			_isLoading = false;
		}

		//
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.vbecsLogo1.Title = "Assign Workload Codes";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC029.FrmAssignWorkloadCodes());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			this.btnLMIPSave.SetToolTip(AddButtonMessage);
			this.btnOK.SetToolTip(SaveButtonMessage);
			this.btnLMIPSave.Text = "&Add";
			this.btnLMIPSave.EnabledButton = false;
			// set custom date and time format
			this.dtpLMIPNLTActivation.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpLMIPNLTInactivation.CustomFormat = Common.VBECSDateTime.DateFormat;
			//
			this.dtpLMIPNLTInactivation.Value = this.dtpLMIPNLTInactivation.MinDate;
			// set current date value based on the division time zone
			this.dtpLMIPNLTActivation.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.ClearInactiveDate();
			//
			this.cmbLMIPNLTCode.SelectedIndex = -1;
			this.cmbLMIPProcedure.SelectedIndex = -1;
		}

		//
		private void SystemError(string reason)
		{
			string message = string.Concat("System Error: ", reason);
			GuiMessenger.ShowMessageBox(this, Common.StrRes.SysErrMsg.Common.Dynamic(message));

			if(_initializeComplete) 
			{
				this.Close();
			}
			else 
			{
				throw new Exception(reason);
			}
		}

		#endregion

		#region Inner Classes

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// Class ProcessItem
		/// </summary>
		private class ProcessItem
		{

			private VbecsProcess _vbecsProcess;

			///<Developers>
			///	<Developer>John Vrooland</Developer>
			///</Developers>
			///<SiteName>Hines OIFO</SiteName>
			///<CreationDate>01/31/2003</CreationDate>
			///
			/// <summary>
			/// ProcessItem
			/// </summary>
			/// <param name="vp"></param>
			public ProcessItem(VbecsProcess vp)
			{
				_vbecsProcess = vp;
			}

			//
			///<Developers>
			///	<Developer>John Vrooland</Developer>
			///</Developers>
			///<SiteName>Hines OIFO</SiteName>
			///<CreationDate>01/31/2003</CreationDate>
			///
			/// <summary>
			/// ToString
			/// </summary>
			/// <returns></returns>
			public override string ToString()
			{
				return _vbecsProcess.VbecsProcessName;
			}

			///<Developers>
			///	<Developer>John Vrooland</Developer>
			///</Developers>
			///<SiteName>Hines OIFO</SiteName>
			///<CreationDate>01/31/2003</CreationDate>
			///
			/// <summary>
			/// Get VbecsProcess
			/// </summary>
			public BOL.VbecsProcess VbecsProcess
			{
				get 
				{
					return _vbecsProcess;
				}
			}

			///<Developers>
			///	<Developer>John Vrooland</Developer>
			///</Developers>
			///<SiteName>Hines OIFO</SiteName>
			///<CreationDate>01/31/2003</CreationDate>
			///
			/// <summary>
			/// Get VbecsProcessId
			/// </summary>
			public int VbecsProcessId
			{
				get 
				{
					return _vbecsProcess.VbecsProcessId;
				}
			}

			//
			public BOL.VbecsProcess VbecsProcessItem
			{
				get 
				{
					return _vbecsProcess;
				}
			}

			//
			public string VbecsProcessName
			{
				get 
				{
					return _vbecsProcess.VbecsProcessName;
				}
			}
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// Class LMIPItem
		/// </summary>
		private class LMIPItem
		{

			private DataRow _lmipRow;

			///<Developers>
			///	<Developer>John Vrooland</Developer>
			///</Developers>
			///<SiteName>Hines OIFO</SiteName>
			///<CreationDate>01/31/2003</CreationDate>
			///
			/// <summary>
			/// LMIPItem
			/// </summary>
			/// <param name="dr"></param>
			public LMIPItem(DataRow dr)
			{
				_lmipRow = dr;
			}

			///<Developers>
			///	<Developer>John Vrooland</Developer>
			///</Developers>
			///<SiteName>Hines OIFO</SiteName>
			///<CreationDate>01/31/2003</CreationDate>
			///
			/// <summary>
			/// Get LMIP
			/// </summary>
			public string LMIP
			{
				get 
				{
					return _lmipRow["LMIP"].ToString();
				}
			}

			///<Developers>
			///	<Developer>John Vrooland</Developer>
			///</Developers>
			///<SiteName>Hines OIFO</SiteName>
			///<CreationDate>01/31/2003</CreationDate>
			///
			/// <summary>
			/// Get Procedure
			/// </summary>
			public string Procedure
			{
				get 
				{
					return _lmipRow["Procedure"].ToString();
				}
			}

			///<Developers>
			///	<Developer>John Vrooland</Developer>
			///</Developers>
			///<SiteName>Hines OIFO</SiteName>
			///<CreationDate>01/31/2003</CreationDate>
			///
			/// <summary>
			/// Get/Set RowValue
			/// </summary>
			public DataRow RowValue
			{
				get 
				{
					return _lmipRow;
				}
				set 
				{
					_lmipRow = value;
				}
			}

			///<Developers>
			///	<Developer>John Vrooland</Developer>
			///</Developers>
			///<SiteName>Hines OIFO</SiteName>
			///<CreationDate>01/31/2003</CreationDate>
			///
			/// <summary>
			/// ToString
			/// </summary>
			/// <returns></returns>
			public override string ToString()
			{
				return _lmipRow["LMIP"].ToString();
			}
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>01/31/2003</CreationDate>
		///
		/// <summary>
		/// ProcedureItem
		/// </summary>
		private class ProcedureItem : LMIPItem
		{

			public ProcedureItem(DataRow dr) : base(dr)
			{
			}

			public override string ToString()
			{
				return this.Procedure;
			}
		}

		#endregion

	}
}
